package module4.udfs

import org.apache.spark.sql.api.java.{UDF2, UDF3, UDF4}
import math.pow

class InterestCapitalizationUDF extends UDF3[Long, Int, Int, Double]{
  override def call(startCapital: Long, yearsAmount: Int, interest: Int): Double = {
    "%.2f".format(startCapital*pow((1 + interest.toDouble/100), yearsAmount)).toDouble
  }
}
